package de.davidartmann.rosa.db.async;

import android.content.Context;
import android.os.AsyncTask;

import de.davidartmann.rosa.db.PersonDao;
import de.davidartmann.rosa.model.Person;

/**
 * AsyncTask to store a Person to the DB.
 * Created by david on 03.03.16.
 */
public class CreateOrUpdatePerson extends AsyncTask<Person, Integer, Person> {

    private Context mContext;
    private PersonDao personDao;
    private boolean mIsUpdate;

    public CreateOrUpdatePerson(Context context, boolean isUpdate) {
        mContext = context;
        mIsUpdate = isUpdate;
    }

    @Override
    protected Person doInBackground(Person... persons) {
        personDao = new PersonDao(mContext);
        personDao.openWritable();
        if (mIsUpdate) {
            return personDao.update(persons[0]);
        } else {
            return personDao.create(persons[0]);

        }
    }

    @Override
    protected void onPostExecute(Person person) {
        super.onPostExecute(person);
        personDao.close();
    }
}
